## Export datasets

#export data: underlying data for figure 2&3

wb <- createWorkbook()

# 1
addWorksheet(wb, "IM")
writeData(wb, "IM", IM_maincountries_adjusted)

# 2
addWorksheet(wb, "EX")
writeData(wb, "EX", EX_maincountries_adjusted)

#save to Excel file

Underlying_data <- file.path(path_to_output, "Underlying_data.xlsx")
saveWorkbook(wb, Underlying_data, overwrite = TRUE)

## Select data to export: for graphic design

#trade deficit
trade_deficit <- EX_total_adjusted %>%
  select(month, EX_2024 = cumsum_2024, EX_2025 = real_cumsum_2025) %>%
  left_join(IM_total_adjusted %>% 
              select(month, IM_2024 = cumsum_2024, IM_2025 = real_cumsum_2025),
            by = "month") %>%
  #trade balance (Exports - Imports)
  mutate(
    deficit_2024 = EX_2024 - IM_2024,
    deficit_2025 = EX_2025 - IM_2025
  ) %>%
  filter(month == "July")%>%
  select(month, IM_2024, IM_2025, EX_2024, EX_2025, deficit_2024, deficit_2025)


#imports

IM_country_adjusted <- IM_maincountries_adjusted%>%
  select(country, month, ytd_compare) %>%
  pivot_wider(
    names_from = month,
    values_from = ytd_compare
  )

#exports
EX_country_adjusted <- EX_maincountries_adjusted %>%
  select(country, month, ytd_compare) %>%
  pivot_wider(
    names_from = month,
    values_from = ytd_compare
  )


wb <- createWorkbook()


# 1
addWorksheet(wb, "Merchandise trade-Total")
writeData(wb, "Merchandise trade-Total", trade_deficit)

# 2
addWorksheet(wb, "Imports-main countries")
writeData(wb, "Imports-main countries", IM_country_adjusted)

# 3
addWorksheet(wb, "Exports-main countries")
writeData(wb, "Exports-main countries", EX_country_adjusted)

#save to Excel file

output_file <- file.path(path_to_output, "output.xlsx")
saveWorkbook(wb, output_file, overwrite = TRUE)

